//
//  $Id: WXKAppDelegate.m 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKAppDelegate.h"
#import "WXKWindowController.h"
#import "WXKPhone.h"


NSString *WXKDefaultsAllowsLaunchingWithoutDriverKey = @"AllowsLaunchingWithoutDriver";


@interface WXKAppDelegate ()

- (BOOL)launchAppWithBundleIdentifier:(NSString *)identifier name:(NSString *)appName localizedName:(NSString *)locName;

@end


#pragma mark -


@implementation WXKAppDelegate

+ (void)initialize
{
    NSUserDefaults *defaults    = [NSUserDefaults standardUserDefaults];
    NSDictionary   *appDefaults = [NSDictionary dictionaryWithObject:[NSNumber numberWithBool:NO]
															  forKey:WXKDefaultsAllowsLaunchingWithoutDriverKey];
    [defaults registerDefaults:appDefaults];
}

#pragma mark Methods delegated by NSApplication

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	// --- Check whether driver is already installed. If driver is not found, quit application. ---
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	
	if ([userDefaults boolForKey:WXKDefaultsAllowsLaunchingWithoutDriverKey] == NO && [WXKPhone existsDriver] == NO)
	{
		NSString *driverName  = [WXKPhone requiredDriverName];
		NSString *message     = NSLocalizedString(@"The %@ doesn't exist.", @"driverNotFoundAlert.message");
		NSString *information = NSLocalizedString(@"You need to install the %@ or later to use this application.", @"driverNotFoundAlert.information");
		
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert addButtonWithTitle:NSLocalizedString(@"Quit", @"driverNotFoundAlert.quitButton")];
		[alert setMessageText:[NSString stringWithFormat:message, driverName]];
		[alert setInformativeText:[NSString stringWithFormat:information, driverName]];
		[alert setAlertStyle:NSCriticalAlertStyle];
		[alert runModal];
		[NSApp terminate:self];
		return;
	}
	
	if ([FJNCoreDataAppDelegate instancesRespondToSelector:@selector(applicationDidFinishLaunching:)])
	{
		[super applicationDidFinishLaunching:aNotification];
	}
	
	[addressWindowController window];
	[bookmarkWindowController window];
	[mailWindowController window];
	[fileWindowController window];
	[addressWindowController showWindow:nil];
	[bookmarkWindowController showWindow:nil];
	[mailWindowController showWindow:nil];
	[fileWindowController showWindow:nil];
}

/* --- Invoked when a file is double clicked or dropped onto the application icon. --- */

- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename
{
	if (bookmarkWindowController && [[filename pathExtension] caseInsensitiveCompare:@"kyoponbookmark"] == NSOrderedSame)
	{
		NSString     *objectUUID     = [[filename lastPathComponent] stringByDeletingPathExtension];
		if (objectUUID == nil) return NO;
		
		NSURL        *pStoreURL      = [bookmarkWindowController URLForPersistentStore];
		NSDictionary *pStoreMetadata = [NSPersistentStoreCoordinator metadataForPersistentStoreWithURL:pStoreURL error:NULL];
		NSString     *pStoreUUID     = [pStoreMetadata objectForKey:NSStoreUUIDKey];
		NSString     *path           = [[@"/" stringByAppendingPathComponent:@"Bookmark"] stringByAppendingPathComponent:objectUUID];
		NSURL        *objectIDAsURL  = [[[NSURL alloc] initWithScheme:@"x-coredata"
																 host:pStoreUUID
																 path:path] autorelease];
		
		if (objectIDAsURL == nil) return NO;
		
		NSManagedObjectID *objectID    = [[bookmarkWindowController persistentStoreCoordinator] managedObjectIDForURIRepresentation:objectIDAsURL];
		if (objectID == nil) return NO;
		
		NSManagedObject   *object      = [[bookmarkWindowController managedObjectContext] objectWithID:objectID];
		if (object == nil) return NO;
		[bookmarkWindowController showWindow:nil];
		
		// Since the managed objects are not yet loaded in case the user started up 
		// the application by double-clicking a file, perform setSelectedObject: lazily. 
		// (This method is invoked before applicationDidFinishLaunching: but
		// array controllers fetch their contexts after the application finished launching.)
		[bookmarkWindowController performSelector:@selector(setSelectedObject:) withObject:object afterDelay:0.0];
		return YES;
	}
	return NO;
}

// --- Invoked when application icon in Dock is cliked or application icon in Finder is double clicked. ---

- (BOOL)applicationShouldHandleReopen:(NSApplication *)theApplication hasVisibleWindows:(BOOL)flag
{
	if ([FJNCoreDataAppDelegate instancesRespondToSelector:@selector(applicationShouldHandleReopen:hasVisibleWindows:)])
	{
		if ([super applicationShouldHandleReopen:theApplication hasVisibleWindows:flag] == NO)
		{
			return NO;
		}
	}
	
	// --- If no window is visible, display main window. ---
	if (flag == NO)
	{
		[addressWindowController showWindow:nil];
		[bookmarkWindowController showWindow:nil];
		[mailWindowController showWindow:nil];
		[fileWindowController showWindow:nil];
	}
	return YES;
}

#pragma mark Action methods

- (IBAction)launchAddressUtility:(id)sender
{
	if (addressWindowController != nil)
	{
		[addressWindowController showWindow:sender];
	}
	else
	{
		[self launchAppWithBundleIdentifier:@"jp.sourceforge.kyoponutilities.KyoponContacts" name:@"Kyopon Address Utility" localizedName:@"Kyopon Address Utility"];
	}
}

- (IBAction)launchBookmarkUtility:(id)sender
{
	if (bookmarkWindowController != nil)
	{
		[bookmarkWindowController showWindow:sender];
	}
	else
	{
		[self launchAppWithBundleIdentifier:@"jp.sourceforge.kyoponutilities.KyoponBookmarks" name:@"Kyopon Bookmark Utility" localizedName:@"Kyopon Bookmark Utility"];
	}
}

- (IBAction)launchFileUtility:(id)sender
{
	if (fileWindowController != nil)
	{
		[fileWindowController showWindow:nil];
	}
	else
	{
		[self launchAppWithBundleIdentifier:@"jp.sourceforge.kyoponutilities.KyoponFiles" name:@"Kyopon File Utility" localizedName:@"Kyopon File Utility"];
	}
}

- (IBAction)launchMailUtility:(id)sender
{
	if (mailWindowController != nil)
	{
		[mailWindowController showWindow:nil];
	}
	else
	{
		[self launchAppWithBundleIdentifier:@"jp.sourceforge.kyoponutilities.KyoponMails" name:@"Kyopon Mail Utility" localizedName:@"Kyopon Mail Utility"];
	}
}

#pragma mark Private methods

- (BOOL)launchAppWithBundleIdentifier:(NSString *)identifier name:(NSString *)appName localizedName:(NSString *)locName
{
	NSWorkspace *workspace = [NSWorkspace sharedWorkspace];
	if ([workspace launchAppWithBundleIdentifier:identifier
										 options:NSWorkspaceLaunchDefault
				  additionalEventParamDescriptor:nil
								launchIdentifier:NULL] ||
		[workspace launchApplication:appName])
	{
		return YES;
	}
	
	NSString *message     = NSLocalizedString(@"“%@” cannot be launched.", @"failToLaunchRelatedUtilityAlert.message");
	NSString *information = NSLocalizedString(@"“%@” may have not been installed, or have been renamed or moved into the trash.", @"failToLaunchRelatedUtilityAlert.information");
	
	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert setMessageText:[NSString stringWithFormat:message, locName]];
	[alert setInformativeText:[NSString stringWithFormat:information, locName]];
	[alert setAlertStyle:NSWarningAlertStyle];
//	[alert setIcon:<#(NSImage *)icon#>];
	[alert runModal];
	
	return NO;
}

@end
